package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait FileSystemType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.FileSystemType
}
object FileSystemType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.FileSystemType
  ): zio.aws.codebuild.model.FileSystemType = value match {
    case software.amazon.awssdk.services.codebuild.model.FileSystemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.FileSystemType.EFS =>
      val r = EFS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.FileSystemType =
      software.amazon.awssdk.services.codebuild.model.FileSystemType.UNKNOWN_TO_SDK_VERSION
  }
  case object EFS extends zio.aws.codebuild.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.FileSystemType =
      software.amazon.awssdk.services.codebuild.model.FileSystemType.EFS
  }
}
