package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{PageSize, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class GetReportGroupTrendRequest(
    reportGroupArn: NonEmptyString,
    numOfReports: Option[PageSize] = None,
    trendField: zio.aws.codebuild.model.ReportGroupTrendFieldType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest = {
    import GetReportGroupTrendRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest
      .builder()
      .reportGroupArn(NonEmptyString.unwrap(reportGroupArn): java.lang.String)
      .optionallyWith(
        numOfReports.map(value => PageSize.unwrap(value): Integer)
      )(_.numOfReports)
      .trendField(trendField.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.GetReportGroupTrendRequest.ReadOnly =
    zio.aws.codebuild.model.GetReportGroupTrendRequest.wrap(buildAwsValue())
}
object GetReportGroupTrendRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.GetReportGroupTrendRequest =
      zio.aws.codebuild.model.GetReportGroupTrendRequest(
        reportGroupArn,
        numOfReports.map(value => value),
        trendField
      )
    def reportGroupArn: NonEmptyString
    def numOfReports: Option[PageSize]
    def trendField: zio.aws.codebuild.model.ReportGroupTrendFieldType
    def getReportGroupArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(reportGroupArn)
    def getNumOfReports: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("numOfReports", numOfReports)
    def getTrendField
        : ZIO[Any, Nothing, zio.aws.codebuild.model.ReportGroupTrendFieldType] =
      ZIO.succeed(trendField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest
  ) extends zio.aws.codebuild.model.GetReportGroupTrendRequest.ReadOnly {
    override val reportGroupArn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.reportGroupArn())
    override val numOfReports: Option[PageSize] = scala
      .Option(impl.numOfReports())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val trendField: zio.aws.codebuild.model.ReportGroupTrendFieldType =
      zio.aws.codebuild.model.ReportGroupTrendFieldType.wrap(impl.trendField())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest
  ): zio.aws.codebuild.model.GetReportGroupTrendRequest.ReadOnly = new Wrapper(
    impl
  )
}
