package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ImagePullCredentialsType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType
}
object ImagePullCredentialsType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType
  ): zio.aws.codebuild.model.ImagePullCredentialsType = value match {
    case software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType.CODEBUILD =>
      val r = CODEBUILD
      r
    case software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType.SERVICE_ROLE =>
      val r = SERVICE_ROLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ImagePullCredentialsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType =
      software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType.UNKNOWN_TO_SDK_VERSION
  }
  case object CODEBUILD
      extends zio.aws.codebuild.model.ImagePullCredentialsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType =
      software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType.CODEBUILD
  }
  case object SERVICE_ROLE
      extends zio.aws.codebuild.model.ImagePullCredentialsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType =
      software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType.SERVICE_ROLE
  }
}
