package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class InvalidateProjectCacheRequest(projectName: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest = {
    import InvalidateProjectCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest
      .builder()
      .projectName(NonEmptyString.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.InvalidateProjectCacheRequest.ReadOnly =
    zio.aws.codebuild.model.InvalidateProjectCacheRequest.wrap(buildAwsValue())
}
object InvalidateProjectCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.InvalidateProjectCacheRequest =
      zio.aws.codebuild.model.InvalidateProjectCacheRequest(projectName)
    def projectName: NonEmptyString
    def getProjectName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest
  ) extends zio.aws.codebuild.model.InvalidateProjectCacheRequest.ReadOnly {
    override val projectName: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest
  ): zio.aws.codebuild.model.InvalidateProjectCacheRequest.ReadOnly =
    new Wrapper(impl)
}
