package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{PageSize, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class ListBuildBatchesForProjectRequest(
    projectName: Option[NonEmptyString] = None,
    filter: Option[zio.aws.codebuild.model.BuildBatchFilter] = None,
    maxResults: Option[PageSize] = None,
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest = {
    import ListBuildBatchesForProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
      .builder()
      .optionallyWith(
        projectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListBuildBatchesForProjectRequest.ReadOnly =
    zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
      .wrap(buildAwsValue())
}
object ListBuildBatchesForProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest =
      zio.aws.codebuild.model.ListBuildBatchesForProjectRequest(
        projectName.map(value => value),
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def projectName: Option[NonEmptyString]
    def filter: Option[zio.aws.codebuild.model.BuildBatchFilter.ReadOnly]
    def maxResults: Option[PageSize]
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Option[String]
    def getProjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.BuildBatchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
  ) extends zio.aws.codebuild.model.ListBuildBatchesForProjectRequest.ReadOnly {
    override val projectName: Option[NonEmptyString] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val filter
        : Option[zio.aws.codebuild.model.BuildBatchFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.codebuild.model.BuildBatchFilter.wrap(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
  ): zio.aws.codebuild.model.ListBuildBatchesForProjectRequest.ReadOnly =
    new Wrapper(impl)
}
