package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListBuildBatchesForProjectResponse(
    ids: Option[Iterable[NonEmptyString]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse = {
    import ListBuildBatchesForProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly =
    zio.aws.codebuild.model.ListBuildBatchesForProjectResponse
      .wrap(buildAwsValue())
}
object ListBuildBatchesForProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildBatchesForProjectResponse =
      zio.aws.codebuild.model.ListBuildBatchesForProjectResponse(
        ids.map(value => value),
        nextToken.map(value => value)
      )
    def ids: Option[List[NonEmptyString]]
    def nextToken: Option[String]
    def getIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ids", ids)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
  ) extends zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly {
    override val ids: Option[List[NonEmptyString]] = scala
      .Option(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
  ): zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly =
    new Wrapper(impl)
}
