package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListReportGroupsResponse(
    nextToken: Option[String] = None,
    reportGroups: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse = {
    import ListReportGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reportGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reportGroups)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly =
    zio.aws.codebuild.model.ListReportGroupsResponse.wrap(buildAwsValue())
}
object ListReportGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListReportGroupsResponse =
      zio.aws.codebuild.model.ListReportGroupsResponse(
        nextToken.map(value => value),
        reportGroups.map(value => value)
      )
    def nextToken: Option[String]
    def reportGroups: Option[List[NonEmptyString]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReportGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("reportGroups", reportGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse
  ) extends zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val reportGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.reportGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse
  ): zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
