package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListReportsForReportGroupResponse(
    nextToken: Option[String] = None,
    reports: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse = {
    import ListReportsForReportGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reports.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reports)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly =
    zio.aws.codebuild.model.ListReportsForReportGroupResponse
      .wrap(buildAwsValue())
}
object ListReportsForReportGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListReportsForReportGroupResponse =
      zio.aws.codebuild.model.ListReportsForReportGroupResponse(
        nextToken.map(value => value),
        reports.map(value => value)
      )
    def nextToken: Option[String]
    def reports: Option[List[NonEmptyString]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReports: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("reports", reports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse
  ) extends zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val reports: Option[List[NonEmptyString]] = scala
      .Option(impl.reports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse
  ): zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly =
    new Wrapper(impl)
}
