package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PhaseContext(
    statusCode: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.PhaseContext = {
    import PhaseContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.PhaseContext
      .builder()
      .optionallyWith(statusCode.map(value => value: java.lang.String))(
        _.statusCode
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.PhaseContext.ReadOnly =
    zio.aws.codebuild.model.PhaseContext.wrap(buildAwsValue())
}
object PhaseContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.PhaseContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.PhaseContext =
      zio.aws.codebuild.model.PhaseContext(
        statusCode.map(value => value),
        message.map(value => value)
      )
    def statusCode: Option[String]
    def message: Option[String]
    def getStatusCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.PhaseContext
  ) extends zio.aws.codebuild.model.PhaseContext.ReadOnly {
    override val statusCode: Option[String] =
      scala.Option(impl.statusCode()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.PhaseContext
  ): zio.aws.codebuild.model.PhaseContext.ReadOnly = new Wrapper(impl)
}
