package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ProjectVisibilityType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType
}
object ProjectVisibilityType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType
  ): zio.aws.codebuild.model.ProjectVisibilityType = value match {
    case software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType.PUBLIC_READ =>
      val r = PUBLIC_READ
      r
    case software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ProjectVisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType =
      software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC_READ
      extends zio.aws.codebuild.model.ProjectVisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType =
      software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType.PUBLIC_READ
  }
  case object PRIVATE extends zio.aws.codebuild.model.ProjectVisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType =
      software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType.PRIVATE
  }
}
