package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codebuild.model.primitives.{
  WrapperBoolean,
  Timestamp,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class Report(
    arn: Option[NonEmptyString] = None,
    `type`: Option[zio.aws.codebuild.model.ReportType] = None,
    name: Option[String] = None,
    reportGroupArn: Option[NonEmptyString] = None,
    executionId: Option[String] = None,
    status: Option[zio.aws.codebuild.model.ReportStatusType] = None,
    created: Option[Timestamp] = None,
    expired: Option[Timestamp] = None,
    exportConfig: Option[zio.aws.codebuild.model.ReportExportConfig] = None,
    truncated: Option[WrapperBoolean] = None,
    testSummary: Option[zio.aws.codebuild.model.TestReportSummary] = None,
    codeCoverageSummary: Option[
      zio.aws.codebuild.model.CodeCoverageReportSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.Report = {
    import Report.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Report
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        reportGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.reportGroupArn)
      .optionallyWith(executionId.map(value => value: java.lang.String))(
        _.executionId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(expired.map(value => Timestamp.unwrap(value): Instant))(
        _.expired
      )
      .optionallyWith(exportConfig.map(value => value.buildAwsValue()))(
        _.exportConfig
      )
      .optionallyWith(
        truncated.map(value => WrapperBoolean.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .optionallyWith(testSummary.map(value => value.buildAwsValue()))(
        _.testSummary
      )
      .optionallyWith(codeCoverageSummary.map(value => value.buildAwsValue()))(
        _.codeCoverageSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Report.ReadOnly =
    zio.aws.codebuild.model.Report.wrap(buildAwsValue())
}
object Report {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Report] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Report =
      zio.aws.codebuild.model.Report(
        arn.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        reportGroupArn.map(value => value),
        executionId.map(value => value),
        status.map(value => value),
        created.map(value => value),
        expired.map(value => value),
        exportConfig.map(value => value.asEditable),
        truncated.map(value => value),
        testSummary.map(value => value.asEditable),
        codeCoverageSummary.map(value => value.asEditable)
      )
    def arn: Option[NonEmptyString]
    def `type`: Option[zio.aws.codebuild.model.ReportType]
    def name: Option[String]
    def reportGroupArn: Option[NonEmptyString]
    def executionId: Option[String]
    def status: Option[zio.aws.codebuild.model.ReportStatusType]
    def created: Option[Timestamp]
    def expired: Option[Timestamp]
    def exportConfig
        : Option[zio.aws.codebuild.model.ReportExportConfig.ReadOnly]
    def truncated: Option[WrapperBoolean]
    def testSummary: Option[zio.aws.codebuild.model.TestReportSummary.ReadOnly]
    def codeCoverageSummary
        : Option[zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.codebuild.model.ReportType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getReportGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportGroupArn", reportGroupArn)
    def getExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getExpired: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expired", expired)
    def getExportConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ReportExportConfig.ReadOnly
    ] = AwsError.unwrapOptionField("exportConfig", exportConfig)
    def getTruncated: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("truncated", truncated)
    def getTestSummary: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.TestReportSummary.ReadOnly
    ] = AwsError.unwrapOptionField("testSummary", testSummary)
    def getCodeCoverageSummary: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly
    ] = AwsError.unwrapOptionField("codeCoverageSummary", codeCoverageSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Report
  ) extends zio.aws.codebuild.model.Report.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val `type`: Option[zio.aws.codebuild.model.ReportType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.codebuild.model.ReportType.wrap(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val reportGroupArn: Option[NonEmptyString] = scala
      .Option(impl.reportGroupArn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val executionId: Option[String] =
      scala.Option(impl.executionId()).map(value => value: String)
    override val status: Option[zio.aws.codebuild.model.ReportStatusType] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.codebuild.model.ReportStatusType.wrap(value))
    override val created: Option[Timestamp] = scala
      .Option(impl.created())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val expired: Option[Timestamp] = scala
      .Option(impl.expired())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val exportConfig
        : Option[zio.aws.codebuild.model.ReportExportConfig.ReadOnly] = scala
      .Option(impl.exportConfig())
      .map(value => zio.aws.codebuild.model.ReportExportConfig.wrap(value))
    override val truncated: Option[WrapperBoolean] = scala
      .Option(impl.truncated())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val testSummary
        : Option[zio.aws.codebuild.model.TestReportSummary.ReadOnly] = scala
      .Option(impl.testSummary())
      .map(value => zio.aws.codebuild.model.TestReportSummary.wrap(value))
    override val codeCoverageSummary
        : Option[zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly] =
      scala
        .Option(impl.codeCoverageSummary())
        .map(value =>
          zio.aws.codebuild.model.CodeCoverageReportSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Report
  ): zio.aws.codebuild.model.Report.ReadOnly = new Wrapper(impl)
}
