package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ReportCodeCoverageSortByType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType
}
object ReportCodeCoverageSortByType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType
  ): zio.aws.codebuild.model.ReportCodeCoverageSortByType = value match {
    case software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType.LINE_COVERAGE_PERCENTAGE =>
      val r = LINE_COVERAGE_PERCENTAGE
      r
    case software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType.FILE_PATH =>
      val r = FILE_PATH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ReportCodeCoverageSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType =
      software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType.UNKNOWN_TO_SDK_VERSION
  }
  case object LINE_COVERAGE_PERCENTAGE
      extends zio.aws.codebuild.model.ReportCodeCoverageSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType =
      software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType.LINE_COVERAGE_PERCENTAGE
  }
  case object FILE_PATH
      extends zio.aws.codebuild.model.ReportCodeCoverageSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType =
      software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType.FILE_PATH
  }
}
