package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResolvedArtifact(
    `type`: Option[zio.aws.codebuild.model.ArtifactsType] = None,
    location: Option[String] = None,
    identifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ResolvedArtifact = {
    import ResolvedArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ResolvedArtifact
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ResolvedArtifact.ReadOnly =
    zio.aws.codebuild.model.ResolvedArtifact.wrap(buildAwsValue())
}
object ResolvedArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ResolvedArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ResolvedArtifact =
      zio.aws.codebuild.model.ResolvedArtifact(
        `type`.map(value => value),
        location.map(value => value),
        identifier.map(value => value)
      )
    def `type`: Option[zio.aws.codebuild.model.ArtifactsType]
    def location: Option[String]
    def identifier: Option[String]
    def getType: ZIO[Any, AwsError, zio.aws.codebuild.model.ArtifactsType] =
      AwsError.unwrapOptionField("type", `type`)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ResolvedArtifact
  ) extends zio.aws.codebuild.model.ResolvedArtifact.ReadOnly {
    override val `type`: Option[zio.aws.codebuild.model.ArtifactsType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.codebuild.model.ArtifactsType.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ResolvedArtifact
  ): zio.aws.codebuild.model.ResolvedArtifact.ReadOnly = new Wrapper(impl)
}
