package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class RetryBuildRequest(
    id: Option[NonEmptyString] = None,
    idempotencyToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.RetryBuildRequest = {
    import RetryBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.RetryBuildRequest
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.RetryBuildRequest.ReadOnly =
    zio.aws.codebuild.model.RetryBuildRequest.wrap(buildAwsValue())
}
object RetryBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.RetryBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.RetryBuildRequest =
      zio.aws.codebuild.model.RetryBuildRequest(
        id.map(value => value),
        idempotencyToken.map(value => value)
      )
    def id: Option[NonEmptyString]
    def idempotencyToken: Option[String]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildRequest
  ) extends zio.aws.codebuild.model.RetryBuildRequest.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildRequest
  ): zio.aws.codebuild.model.RetryBuildRequest.ReadOnly = new Wrapper(impl)
}
