package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateWebhookResponse(
    webhook: Option[zio.aws.codebuild.model.Webhook] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse = {
    import UpdateWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse
      .builder()
      .optionallyWith(webhook.map(value => value.buildAwsValue()))(_.webhook)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly =
    zio.aws.codebuild.model.UpdateWebhookResponse.wrap(buildAwsValue())
}
object UpdateWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateWebhookResponse =
      zio.aws.codebuild.model
        .UpdateWebhookResponse(webhook.map(value => value.asEditable))
    def webhook: Option[zio.aws.codebuild.model.Webhook.ReadOnly]
    def getWebhook
        : ZIO[Any, AwsError, zio.aws.codebuild.model.Webhook.ReadOnly] =
      AwsError.unwrapOptionField("webhook", webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse
  ) extends zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly {
    override val webhook: Option[zio.aws.codebuild.model.Webhook.ReadOnly] =
      scala
        .Option(impl.webhook())
        .map(value => zio.aws.codebuild.model.Webhook.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse
  ): zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly = new Wrapper(impl)
}
