package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSubscriptionRequest(spaceName: NameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest = {
    import GetSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetSubscriptionRequest.ReadOnly =
    zio.aws.codecatalyst.model.GetSubscriptionRequest.wrap(buildAwsValue())
}
object GetSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetSubscriptionRequest =
      zio.aws.codecatalyst.model.GetSubscriptionRequest(spaceName)
    def spaceName: NameString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest
  ) extends zio.aws.codecatalyst.model.GetSubscriptionRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest
  ): zio.aws.codecatalyst.model.GetSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
