package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetUserDetailsResponse(
    userId: Optional[String] = Optional.Absent,
    userName: Optional[String] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    primaryEmail: Optional[zio.aws.codecatalyst.model.EmailAddress] =
      Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse = {
    import GetUserDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse
      .builder()
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(primaryEmail.map(value => value.buildAwsValue()))(
        _.primaryEmail
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly =
    zio.aws.codecatalyst.model.GetUserDetailsResponse.wrap(buildAwsValue())
}
object GetUserDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetUserDetailsResponse =
      zio.aws.codecatalyst.model.GetUserDetailsResponse(
        userId.map(value => value),
        userName.map(value => value),
        displayName.map(value => value),
        primaryEmail.map(value => value.asEditable),
        version.map(value => value)
      )
    def userId: Optional[String]
    def userName: Optional[String]
    def displayName: Optional[String]
    def primaryEmail: Optional[zio.aws.codecatalyst.model.EmailAddress.ReadOnly]
    def version: Optional[String]
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getPrimaryEmail
        : ZIO[Any, AwsError, zio.aws.codecatalyst.model.EmailAddress.ReadOnly] =
      AwsError.unwrapOptionField("primaryEmail", primaryEmail)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse
  ) extends zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly {
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
    override val userName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => value: String)
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val primaryEmail
        : Optional[zio.aws.codecatalyst.model.EmailAddress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryEmail())
        .map(value => zio.aws.codecatalyst.model.EmailAddress.wrap(value))
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse
  ): zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly = new Wrapper(
    impl
  )
}
