package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListDevEnvironmentsRequestMaxResultsInteger,
  ListDevEnvironmentsRequestNextTokenString,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDevEnvironmentsRequest(
    spaceName: NameString,
    projectName: NameString,
    filters: Optional[Iterable[zio.aws.codecatalyst.model.Filter]] =
      Optional.Absent,
    nextToken: Optional[ListDevEnvironmentsRequestNextTokenString] =
      Optional.Absent,
    maxResults: Optional[ListDevEnvironmentsRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest = {
    import ListDevEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value =>
          ListDevEnvironmentsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListDevEnvironmentsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListDevEnvironmentsRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListDevEnvironmentsRequest.wrap(buildAwsValue())
}
object ListDevEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListDevEnvironmentsRequest =
      zio.aws.codecatalyst.model.ListDevEnvironmentsRequest(
        spaceName,
        projectName,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def filters: Optional[List[zio.aws.codecatalyst.model.Filter.ReadOnly]]
    def nextToken: Optional[ListDevEnvironmentsRequestNextTokenString]
    def maxResults: Optional[ListDevEnvironmentsRequestMaxResultsInteger]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.codecatalyst.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken
        : ZIO[Any, AwsError, ListDevEnvironmentsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListDevEnvironmentsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest
  ) extends zio.aws.codecatalyst.model.ListDevEnvironmentsRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val filters
        : Optional[List[zio.aws.codecatalyst.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken
        : Optional[ListDevEnvironmentsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListDevEnvironmentsRequestNextTokenString(value)
        )
    override val maxResults
        : Optional[ListDevEnvironmentsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListDevEnvironmentsRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest
  ): zio.aws.codecatalyst.model.ListDevEnvironmentsRequest.ReadOnly =
    new Wrapper(impl)
}
