package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ErrorMessage, ErrorCode, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetCommitsError(
    commitId: Optional[ObjectId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError = {
    import BatchGetCommitsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly =
    zio.aws.codecommit.model.BatchGetCommitsError.wrap(buildAwsValue())
}
object BatchGetCommitsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetCommitsError =
      zio.aws.codecommit.model.BatchGetCommitsError(
        commitId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def commitId: Optional[ObjectId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
  ) extends zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly {
    override val commitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.codecommit.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.codecommit.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
  ): zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly = new Wrapper(impl)
}
