package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ClientRequestToken,
  Description,
  Title
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePullRequestRequest(
    title: Title,
    description: Optional[Description] = Optional.Absent,
    targets: Iterable[zio.aws.codecommit.model.Target],
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest = {
    import CreatePullRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest
      .builder()
      .title(Title.unwrap(title): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreatePullRequestRequest.ReadOnly =
    zio.aws.codecommit.model.CreatePullRequestRequest.wrap(buildAwsValue())
}
object CreatePullRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreatePullRequestRequest =
      zio.aws.codecommit.model.CreatePullRequestRequest(
        title,
        description.map(value => value),
        targets.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value)
      )
    def title: Title
    def description: Optional[Description]
    def targets: List[zio.aws.codecommit.model.Target.ReadOnly]
    def clientRequestToken: Optional[ClientRequestToken]
    def getTitle: ZIO[Any, Nothing, Title] = ZIO.succeed(title)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTargets
        : ZIO[Any, Nothing, List[zio.aws.codecommit.model.Target.ReadOnly]] =
      ZIO.succeed(targets)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest
  ) extends zio.aws.codecommit.model.CreatePullRequestRequest.ReadOnly {
    override val title: Title =
      zio.aws.codecommit.model.primitives.Title(impl.title())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codecommit.model.primitives.Description(value))
    override val targets: List[zio.aws.codecommit.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.Target.wrap(item)
      }
      .toList
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codecommit.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest
  ): zio.aws.codecommit.model.CreatePullRequestRequest.ReadOnly = new Wrapper(
    impl
  )
}
