package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitName,
  KeepEmptyFolders,
  Message,
  RepositoryName,
  Email,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUnreferencedMergeCommitRequest(
    repositoryName: RepositoryName,
    sourceCommitSpecifier: CommitName,
    destinationCommitSpecifier: CommitName,
    mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum,
    conflictDetailLevel: Optional[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = Optional.Absent,
    conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = Optional.Absent,
    authorName: Optional[Name] = Optional.Absent,
    email: Optional[Email] = Optional.Absent,
    commitMessage: Optional[Message] = Optional.Absent,
    keepEmptyFolders: Optional[KeepEmptyFolders] = Optional.Absent,
    conflictResolution: Optional[zio.aws.codecommit.model.ConflictResolution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest = {
    import CreateUnreferencedMergeCommitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .sourceCommitSpecifier(
        CommitName.unwrap(sourceCommitSpecifier): java.lang.String
      )
      .destinationCommitSpecifier(
        CommitName.unwrap(destinationCommitSpecifier): java.lang.String
      )
      .mergeOption(mergeOption.unwrap)
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .optionallyWith(
        authorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(conflictResolution.map(value => value.buildAwsValue()))(
        _.conflictResolution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest.ReadOnly =
    zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest
      .wrap(buildAwsValue())
}
object CreateUnreferencedMergeCommitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest =
      zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest(
        repositoryName,
        sourceCommitSpecifier,
        destinationCommitSpecifier,
        mergeOption,
        conflictDetailLevel.map(value => value),
        conflictResolutionStrategy.map(value => value),
        authorName.map(value => value),
        email.map(value => value),
        commitMessage.map(value => value),
        keepEmptyFolders.map(value => value),
        conflictResolution.map(value => value.asEditable)
      )
    def repositoryName: RepositoryName
    def sourceCommitSpecifier: CommitName
    def destinationCommitSpecifier: CommitName
    def mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum
    def conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def conflictResolutionStrategy
        : Optional[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def authorName: Optional[Name]
    def email: Optional[Email]
    def commitMessage: Optional[Message]
    def keepEmptyFolders: Optional[KeepEmptyFolders]
    def conflictResolution
        : Optional[zio.aws.codecommit.model.ConflictResolution.ReadOnly]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(sourceCommitSpecifier)
    def getDestinationCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(destinationCommitSpecifier)
    def getMergeOption
        : ZIO[Any, Nothing, zio.aws.codecommit.model.MergeOptionTypeEnum] =
      ZIO.succeed(mergeOption)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
    def getAuthorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getConflictResolution: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolution.ReadOnly
    ] = AwsError.unwrapOptionField("conflictResolution", conflictResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest
  ) extends zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.sourceCommitSpecifier())
    override val destinationCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.destinationCommitSpecifier())
    override val mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum =
      zio.aws.codecommit.model.MergeOptionTypeEnum.wrap(impl.mergeOption())
    override val conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictDetailLevel())
        .map(value =>
          zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
        )
    override val conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conflictResolutionStrategy())
      .map(value =>
        zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum.wrap(value)
      )
    override val authorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.authorName())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val commitMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val keepEmptyFolders: Optional[KeepEmptyFolders] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keepEmptyFolders())
        .map(value =>
          zio.aws.codecommit.model.primitives.KeepEmptyFolders(value)
        )
    override val conflictResolution
        : Optional[zio.aws.codecommit.model.ConflictResolution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictResolution())
        .map(value => zio.aws.codecommit.model.ConflictResolution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest
  ): zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest.ReadOnly =
    new Wrapper(impl)
}
