package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteCommentContentResponse(
    comment: Optional[zio.aws.codecommit.model.Comment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse = {
    import DeleteCommentContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly =
    zio.aws.codecommit.model.DeleteCommentContentResponse.wrap(buildAwsValue())
}
object DeleteCommentContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteCommentContentResponse =
      zio.aws.codecommit.model
        .DeleteCommentContentResponse(comment.map(value => value.asEditable))
    def comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly]
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse
  ) extends zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly {
    override val comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse
  ): zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly =
    new Wrapper(impl)
}
