package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.Path
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteFileEntry(filePath: Path) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteFileEntry = {
    import DeleteFileEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteFileEntry
      .builder()
      .filePath(Path.unwrap(filePath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteFileEntry.ReadOnly =
    zio.aws.codecommit.model.DeleteFileEntry.wrap(buildAwsValue())
}
object DeleteFileEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteFileEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteFileEntry =
      zio.aws.codecommit.model.DeleteFileEntry(filePath)
    def filePath: Path
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteFileEntry
  ) extends zio.aws.codecommit.model.DeleteFileEntry.ReadOnly {
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteFileEntry
  ): zio.aws.codecommit.model.DeleteFileEntry.ReadOnly = new Wrapper(impl)
}
