package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  Arn,
  PullRequestId
}
import scala.jdk.CollectionConverters.*
final case class DescribePullRequestEventsRequest(
    pullRequestId: PullRequestId,
    pullRequestEventType: Optional[
      zio.aws.codecommit.model.PullRequestEventType
    ] = Optional.Absent,
    actorArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest = {
    import DescribePullRequestEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .optionallyWith(pullRequestEventType.map(value => value.unwrap))(
        _.pullRequestEventType
      )
      .optionallyWith(
        actorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.actorArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DescribePullRequestEventsRequest.ReadOnly =
    zio.aws.codecommit.model.DescribePullRequestEventsRequest
      .wrap(buildAwsValue())
}
object DescribePullRequestEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DescribePullRequestEventsRequest =
      zio.aws.codecommit.model.DescribePullRequestEventsRequest(
        pullRequestId,
        pullRequestEventType.map(value => value),
        actorArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pullRequestId: PullRequestId
    def pullRequestEventType
        : Optional[zio.aws.codecommit.model.PullRequestEventType]
    def actorArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getPullRequestEventType
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestEventType] =
      AwsError.unwrapOptionField("pullRequestEventType", pullRequestEventType)
    def getActorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("actorArn", actorArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
  ) extends zio.aws.codecommit.model.DescribePullRequestEventsRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val pullRequestEventType
        : Optional[zio.aws.codecommit.model.PullRequestEventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullRequestEventType())
        .map(value => zio.aws.codecommit.model.PullRequestEventType.wrap(value))
    override val actorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.actorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
  ): zio.aws.codecommit.model.DescribePullRequestEventsRequest.ReadOnly =
    new Wrapper(impl)
}
