package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait FileModeTypeEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum
}
object FileModeTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum
  ): zio.aws.codecommit.model.FileModeTypeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.EXECUTABLE =>
      val r = EXECUTABLE
      r
    case software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.NORMAL =>
      val r = NORMAL
      r
    case software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.SYMLINK =>
      val r = SYMLINK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.FileModeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object EXECUTABLE extends zio.aws.codecommit.model.FileModeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.EXECUTABLE
  }
  case object NORMAL extends zio.aws.codecommit.model.FileModeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.NORMAL
  }
  case object SYMLINK extends zio.aws.codecommit.model.FileModeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum.SYMLINK
  }
}
