package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.Blob
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBlobResponse(content: Blob) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetBlobResponse = {
    import GetBlobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetBlobResponse
      .builder()
      .content(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(content.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetBlobResponse.ReadOnly =
    zio.aws.codecommit.model.GetBlobResponse.wrap(buildAwsValue())
}
object GetBlobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetBlobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetBlobResponse =
      zio.aws.codecommit.model.GetBlobResponse(content)
    def content: Blob
    def getContent: ZIO[Any, Nothing, Blob] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetBlobResponse
  ) extends zio.aws.codecommit.model.GetBlobResponse.ReadOnly {
    override val content: Blob = zio.aws.codecommit.model.primitives
      .Blob(zio.Chunk.fromArray(impl.content().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetBlobResponse
  ): zio.aws.codecommit.model.GetBlobResponse.ReadOnly = new Wrapper(impl)
}
