package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  CommitId,
  RepositoryName
}
import scala.jdk.CollectionConverters.*
final case class GetCommentsForComparedCommitRequest(
    repositoryName: RepositoryName,
    beforeCommitId: Optional[CommitId] = Optional.Absent,
    afterCommitId: CommitId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest = {
    import GetCommentsForComparedCommitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .afterCommitId(CommitId.unwrap(afterCommitId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetCommentsForComparedCommitRequest.ReadOnly =
    zio.aws.codecommit.model.GetCommentsForComparedCommitRequest
      .wrap(buildAwsValue())
}
object GetCommentsForComparedCommitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetCommentsForComparedCommitRequest =
      zio.aws.codecommit.model.GetCommentsForComparedCommitRequest(
        repositoryName,
        beforeCommitId.map(value => value),
        afterCommitId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def repositoryName: RepositoryName
    def beforeCommitId: Optional[CommitId]
    def afterCommitId: CommitId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, Nothing, CommitId] =
      ZIO.succeed(afterCommitId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest
  ) extends zio.aws.codecommit.model.GetCommentsForComparedCommitRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val beforeCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: CommitId =
      zio.aws.codecommit.model.primitives.CommitId(impl.afterCommitId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest
  ): zio.aws.codecommit.model.GetCommentsForComparedCommitRequest.ReadOnly =
    new Wrapper(impl)
}
