package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  NextToken,
  CommitId,
  RepositoryName,
  PullRequestId,
  MaxResults
}
import scala.jdk.CollectionConverters.*
final case class GetCommentsForPullRequestRequest(
    pullRequestId: PullRequestId,
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    beforeCommitId: Optional[CommitId] = Optional.Absent,
    afterCommitId: Optional[CommitId] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest = {
    import GetCommentsForPullRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetCommentsForPullRequestRequest.ReadOnly =
    zio.aws.codecommit.model.GetCommentsForPullRequestRequest
      .wrap(buildAwsValue())
}
object GetCommentsForPullRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommentsForPullRequestRequest =
      zio.aws.codecommit.model.GetCommentsForPullRequestRequest(
        pullRequestId,
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pullRequestId: PullRequestId
    def repositoryName: Optional[RepositoryName]
    def beforeCommitId: Optional[CommitId]
    def afterCommitId: Optional[CommitId]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest
  ) extends zio.aws.codecommit.model.GetCommentsForPullRequestRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest
  ): zio.aws.codecommit.model.GetCommentsForPullRequestRequest.ReadOnly =
    new Wrapper(impl)
}
