package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RevisionId, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OverridePullRequestApprovalRulesRequest(
    pullRequestId: PullRequestId,
    revisionId: RevisionId,
    overrideStatus: zio.aws.codecommit.model.OverrideStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest = {
    import OverridePullRequestApprovalRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .overrideStatus(overrideStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest.ReadOnly =
    zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest
      .wrap(buildAwsValue())
}
object OverridePullRequestApprovalRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest =
      zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest(
        pullRequestId,
        revisionId,
        overrideStatus
      )
    def pullRequestId: PullRequestId
    def revisionId: RevisionId
    def overrideStatus: zio.aws.codecommit.model.OverrideStatus
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
    def getOverrideStatus
        : ZIO[Any, Nothing, zio.aws.codecommit.model.OverrideStatus] =
      ZIO.succeed(overrideStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest
  ) extends zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val revisionId: RevisionId =
      zio.aws.codecommit.model.primitives.RevisionId(impl.revisionId())
    override val overrideStatus: zio.aws.codecommit.model.OverrideStatus =
      zio.aws.codecommit.model.OverrideStatus.wrap(impl.overrideStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest
  ): zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest.ReadOnly =
    new Wrapper(impl)
}
