package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.Path
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetFileModeEntry(
    filePath: Path,
    fileMode: zio.aws.codecommit.model.FileModeTypeEnum
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.SetFileModeEntry = {
    import SetFileModeEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.SetFileModeEntry
      .builder()
      .filePath(Path.unwrap(filePath): java.lang.String)
      .fileMode(fileMode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.SetFileModeEntry.ReadOnly =
    zio.aws.codecommit.model.SetFileModeEntry.wrap(buildAwsValue())
}
object SetFileModeEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.SetFileModeEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.SetFileModeEntry =
      zio.aws.codecommit.model.SetFileModeEntry(filePath, fileMode)
    def filePath: Path
    def fileMode: zio.aws.codecommit.model.FileModeTypeEnum
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getFileMode
        : ZIO[Any, Nothing, zio.aws.codecommit.model.FileModeTypeEnum] =
      ZIO.succeed(fileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.SetFileModeEntry
  ) extends zio.aws.codecommit.model.SetFileModeEntry.ReadOnly {
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val fileMode: zio.aws.codecommit.model.FileModeTypeEnum =
      zio.aws.codecommit.model.FileModeTypeEnum.wrap(impl.fileMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.SetFileModeEntry
  ): zio.aws.codecommit.model.SetFileModeEntry.ReadOnly = new Wrapper(impl)
}
