package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateCommentResponse(
    comment: Optional[zio.aws.codecommit.model.Comment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse = {
    import UpdateCommentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly =
    zio.aws.codecommit.model.UpdateCommentResponse.wrap(buildAwsValue())
}
object UpdateCommentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdateCommentResponse =
      zio.aws.codecommit.model
        .UpdateCommentResponse(comment.map(value => value.asEditable))
    def comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly]
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
  ) extends zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly {
    override val comment: Optional[zio.aws.codecommit.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
  ): zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly = new Wrapper(impl)
}
