package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  ApprovalRuleTemplateName
}
import scala.jdk.CollectionConverters.*
final case class ListRepositoriesForApprovalRuleTemplateRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest = {
    import ListRepositoriesForApprovalRuleTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest.ReadOnly =
    zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
      .wrap(buildAwsValue())
}
object ListRepositoriesForApprovalRuleTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest =
      zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest(
        approvalRuleTemplateName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ) extends zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ): zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
