package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.IsHunkConflict
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MergeHunk(
    isConflict: Optional[IsHunkConflict] = Optional.Absent,
    source: Optional[zio.aws.codecommit.model.MergeHunkDetail] =
      Optional.Absent,
    destination: Optional[zio.aws.codecommit.model.MergeHunkDetail] =
      Optional.Absent,
    base: Optional[zio.aws.codecommit.model.MergeHunkDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeHunk = {
    import MergeHunk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeHunk
      .builder()
      .optionallyWith(
        isConflict.map(value => IsHunkConflict.unwrap(value): java.lang.Boolean)
      )(_.isConflict)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(base.map(value => value.buildAwsValue()))(_.base)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.MergeHunk.ReadOnly =
    zio.aws.codecommit.model.MergeHunk.wrap(buildAwsValue())
}
object MergeHunk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeHunk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeHunk =
      zio.aws.codecommit.model.MergeHunk(
        isConflict.map(value => value),
        source.map(value => value.asEditable),
        destination.map(value => value.asEditable),
        base.map(value => value.asEditable)
      )
    def isConflict: Optional[IsHunkConflict]
    def source: Optional[zio.aws.codecommit.model.MergeHunkDetail.ReadOnly]
    def destination: Optional[zio.aws.codecommit.model.MergeHunkDetail.ReadOnly]
    def base: Optional[zio.aws.codecommit.model.MergeHunkDetail.ReadOnly]
    def getIsConflict: ZIO[Any, AwsError, IsHunkConflict] =
      AwsError.unwrapOptionField("isConflict", isConflict)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.MergeHunkDetail.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.MergeHunkDetail.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getBase: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.MergeHunkDetail.ReadOnly
    ] = AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeHunk
  ) extends zio.aws.codecommit.model.MergeHunk.ReadOnly {
    override val isConflict: Optional[IsHunkConflict] = zio.aws.core.internal
      .optionalFromNullable(impl.isConflict())
      .map(value => zio.aws.codecommit.model.primitives.IsHunkConflict(value))
    override val source
        : Optional[zio.aws.codecommit.model.MergeHunkDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.codecommit.model.MergeHunkDetail.wrap(value))
    override val destination
        : Optional[zio.aws.codecommit.model.MergeHunkDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.codecommit.model.MergeHunkDetail.wrap(value))
    override val base
        : Optional[zio.aws.codecommit.model.MergeHunkDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.base())
        .map(value => zio.aws.codecommit.model.MergeHunkDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeHunk
  ): zio.aws.codecommit.model.MergeHunk.ReadOnly = new Wrapper(impl)
}
