package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait SortByEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.SortByEnum
}
object SortByEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.SortByEnum
  ): zio.aws.codecommit.model.SortByEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.SortByEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.SortByEnum.REPOSITORY_NAME =>
      val r = repositoryName
      r
    case software.amazon.awssdk.services.codecommit.model.SortByEnum.LAST_MODIFIED_DATE =>
      val r = lastModifiedDate
      r
  }
  case object unknownToSdkVersion extends zio.aws.codecommit.model.SortByEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.SortByEnum =
      software.amazon.awssdk.services.codecommit.model.SortByEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object repositoryName extends zio.aws.codecommit.model.SortByEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.SortByEnum =
      software.amazon.awssdk.services.codecommit.model.SortByEnum.REPOSITORY_NAME
  }
  case object lastModifiedDate extends zio.aws.codecommit.model.SortByEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.SortByEnum =
      software.amazon.awssdk.services.codecommit.model.SortByEnum.LAST_MODIFIED_DATE
  }
}
