package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestRepositoryTriggersRequest(
    repositoryName: RepositoryName,
    triggers: Iterable[zio.aws.codecommit.model.RepositoryTrigger]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest = {
    import TestRepositoryTriggersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .triggers(triggers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.TestRepositoryTriggersRequest.ReadOnly =
    zio.aws.codecommit.model.TestRepositoryTriggersRequest.wrap(buildAwsValue())
}
object TestRepositoryTriggersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.TestRepositoryTriggersRequest =
      zio.aws.codecommit.model.TestRepositoryTriggersRequest(
        repositoryName,
        triggers.map { item =>
          item.asEditable
        }
      )
    def repositoryName: RepositoryName
    def triggers: List[zio.aws.codecommit.model.RepositoryTrigger.ReadOnly]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getTriggers: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.RepositoryTrigger.ReadOnly
    ]] = ZIO.succeed(triggers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest
  ) extends zio.aws.codecommit.model.TestRepositoryTriggersRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val triggers
        : List[zio.aws.codecommit.model.RepositoryTrigger.ReadOnly] = impl
      .triggers()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.RepositoryTrigger.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest
  ): zio.aws.codecommit.model.TestRepositoryTriggersRequest.ReadOnly =
    new Wrapper(impl)
}
