package zio.aws.codecommit.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleTemplateId,
  ApprovalRuleTemplateContent,
  ApprovalRuleTemplateName,
  Arn,
  ApprovalRuleTemplateDescription,
  LastModifiedDate,
  RuleContentSha256,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class ApprovalRuleTemplate(
    approvalRuleTemplateId: Optional[ApprovalRuleTemplateId] = Optional.Absent,
    approvalRuleTemplateName: Optional[ApprovalRuleTemplateName] =
      Optional.Absent,
    approvalRuleTemplateDescription: Optional[ApprovalRuleTemplateDescription] =
      Optional.Absent,
    approvalRuleTemplateContent: Optional[ApprovalRuleTemplateContent] =
      Optional.Absent,
    ruleContentSha256: Optional[RuleContentSha256] = Optional.Absent,
    lastModifiedDate: Optional[LastModifiedDate] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    lastModifiedUser: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate = {
    import ApprovalRuleTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
      .builder()
      .optionallyWith(
        approvalRuleTemplateId.map(value =>
          ApprovalRuleTemplateId.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateId)
      .optionallyWith(
        approvalRuleTemplateName.map(value =>
          ApprovalRuleTemplateName.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateName)
      .optionallyWith(
        approvalRuleTemplateDescription.map(value =>
          ApprovalRuleTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateDescription)
      .optionallyWith(
        approvalRuleTemplateContent.map(value =>
          ApprovalRuleTemplateContent.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateContent)
      .optionallyWith(
        ruleContentSha256.map(value =>
          RuleContentSha256.unwrap(value): java.lang.String
        )
      )(_.ruleContentSha256)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedUser.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastModifiedUser)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ApprovalRuleTemplate.ReadOnly =
    zio.aws.codecommit.model.ApprovalRuleTemplate.wrap(buildAwsValue())
}
object ApprovalRuleTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ApprovalRuleTemplate =
      zio.aws.codecommit.model.ApprovalRuleTemplate(
        approvalRuleTemplateId.map(value => value),
        approvalRuleTemplateName.map(value => value),
        approvalRuleTemplateDescription.map(value => value),
        approvalRuleTemplateContent.map(value => value),
        ruleContentSha256.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        lastModifiedUser.map(value => value)
      )
    def approvalRuleTemplateId: Optional[ApprovalRuleTemplateId]
    def approvalRuleTemplateName: Optional[ApprovalRuleTemplateName]
    def approvalRuleTemplateDescription
        : Optional[ApprovalRuleTemplateDescription]
    def approvalRuleTemplateContent: Optional[ApprovalRuleTemplateContent]
    def ruleContentSha256: Optional[RuleContentSha256]
    def lastModifiedDate: Optional[LastModifiedDate]
    def creationDate: Optional[CreationDate]
    def lastModifiedUser: Optional[Arn]
    def getApprovalRuleTemplateId: ZIO[Any, AwsError, ApprovalRuleTemplateId] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateId",
        approvalRuleTemplateId
      )
    def getApprovalRuleTemplateName
        : ZIO[Any, AwsError, ApprovalRuleTemplateName] = AwsError
      .unwrapOptionField("approvalRuleTemplateName", approvalRuleTemplateName)
    def getApprovalRuleTemplateDescription
        : ZIO[Any, AwsError, ApprovalRuleTemplateDescription] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateDescription",
        approvalRuleTemplateDescription
      )
    def getApprovalRuleTemplateContent
        : ZIO[Any, AwsError, ApprovalRuleTemplateContent] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateContent",
        approvalRuleTemplateContent
      )
    def getRuleContentSha256: ZIO[Any, AwsError, RuleContentSha256] =
      AwsError.unwrapOptionField("ruleContentSha256", ruleContentSha256)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedUser: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
  ) extends zio.aws.codecommit.model.ApprovalRuleTemplate.ReadOnly {
    override val approvalRuleTemplateId: Optional[ApprovalRuleTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleTemplateId())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateId(value)
        )
    override val approvalRuleTemplateName: Optional[ApprovalRuleTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleTemplateName())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName(value)
        )
    override val approvalRuleTemplateDescription
        : Optional[ApprovalRuleTemplateDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalRuleTemplateDescription())
      .map(value =>
        zio.aws.codecommit.model.primitives
          .ApprovalRuleTemplateDescription(value)
      )
    override val approvalRuleTemplateContent
        : Optional[ApprovalRuleTemplateContent] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalRuleTemplateContent())
      .map(value =>
        zio.aws.codecommit.model.primitives.ApprovalRuleTemplateContent(value)
      )
    override val ruleContentSha256: Optional[RuleContentSha256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleContentSha256())
        .map(value =>
          zio.aws.codecommit.model.primitives.RuleContentSha256(value)
        )
    override val lastModifiedDate: Optional[LastModifiedDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDate())
        .map(value =>
          zio.aws.codecommit.model.primitives.LastModifiedDate(value)
        )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val lastModifiedUser: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedUser())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
  ): zio.aws.codecommit.model.ApprovalRuleTemplate.ReadOnly = new Wrapper(impl)
}
