package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait OverrideStatus {
  def unwrap: software.amazon.awssdk.services.codecommit.model.OverrideStatus
}
object OverrideStatus {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.OverrideStatus
  ): zio.aws.codecommit.model.OverrideStatus = value match {
    case software.amazon.awssdk.services.codecommit.model.OverrideStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.OverrideStatus.OVERRIDE =>
      val r = OVERRIDE
      r
    case software.amazon.awssdk.services.codecommit.model.OverrideStatus.REVOKE =>
      val r = REVOKE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.OverrideStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.OverrideStatus =
      software.amazon.awssdk.services.codecommit.model.OverrideStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OVERRIDE extends zio.aws.codecommit.model.OverrideStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.OverrideStatus =
      software.amazon.awssdk.services.codecommit.model.OverrideStatus.OVERRIDE
  }
  case object REVOKE extends zio.aws.codecommit.model.OverrideStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.OverrideStatus =
      software.amazon.awssdk.services.codecommit.model.OverrideStatus.REVOKE
  }
}
