package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{IsMove, Path}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceFileSpecifier(
    filePath: Path,
    isMove: Optional[IsMove] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.SourceFileSpecifier = {
    import SourceFileSpecifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.SourceFileSpecifier
      .builder()
      .filePath(Path.unwrap(filePath): java.lang.String)
      .optionallyWith(
        isMove.map(value => IsMove.unwrap(value): java.lang.Boolean)
      )(_.isMove)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.SourceFileSpecifier.ReadOnly =
    zio.aws.codecommit.model.SourceFileSpecifier.wrap(buildAwsValue())
}
object SourceFileSpecifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.SourceFileSpecifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.SourceFileSpecifier =
      zio.aws.codecommit.model
        .SourceFileSpecifier(filePath, isMove.map(value => value))
    def filePath: Path
    def isMove: Optional[IsMove]
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getIsMove: ZIO[Any, AwsError, IsMove] =
      AwsError.unwrapOptionField("isMove", isMove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.SourceFileSpecifier
  ) extends zio.aws.codecommit.model.SourceFileSpecifier.ReadOnly {
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val isMove: Optional[IsMove] = zio.aws.core.internal
      .optionalFromNullable(impl.isMove())
      .map(value => zio.aws.codecommit.model.primitives.IsMove(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.SourceFileSpecifier
  ): zio.aws.codecommit.model.SourceFileSpecifier.ReadOnly = new Wrapper(impl)
}
