package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRepositoryNameRequest(
    oldName: RepositoryName,
    newName: RepositoryName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest = {
    import UpdateRepositoryNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest
      .builder()
      .oldName(RepositoryName.unwrap(oldName): java.lang.String)
      .newName(RepositoryName.unwrap(newName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateRepositoryNameRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateRepositoryNameRequest.wrap(buildAwsValue())
}
object UpdateRepositoryNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdateRepositoryNameRequest =
      zio.aws.codecommit.model.UpdateRepositoryNameRequest(oldName, newName)
    def oldName: RepositoryName
    def newName: RepositoryName
    def getOldName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(oldName)
    def getNewName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(newName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest
  ) extends zio.aws.codecommit.model.UpdateRepositoryNameRequest.ReadOnly {
    override val oldName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.oldName())
    override val newName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.newName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest
  ): zio.aws.codecommit.model.UpdateRepositoryNameRequest.ReadOnly =
    new Wrapper(impl)
}
