package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RepositoryName,
  ApprovalRuleTemplateName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    repositoryNames: Iterable[RepositoryName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest = {
    import BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .repositoryNames(repositoryNames.map { item =>
        RepositoryName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.ReadOnly =
    zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
      .wrap(buildAwsValue())
}
object BatchAssociateApprovalRuleTemplateWithRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest =
      zio.aws.codecommit.model
        .BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(
          approvalRuleTemplateName,
          repositoryNames
        )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def repositoryNames: List[RepositoryName]
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getRepositoryNames: ZIO[Any, Nothing, List[RepositoryName]] =
      ZIO.succeed(repositoryNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
  ) extends zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val repositoryNames: List[RepositoryName] = impl
      .repositoryNames()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.primitives.RepositoryName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
  ): zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.ReadOnly =
    new Wrapper(impl)
}
