package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePullRequestEventsResponse(
    pullRequestEvents: Iterable[zio.aws.codecommit.model.PullRequestEvent],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse = {
    import DescribePullRequestEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse
      .builder()
      .pullRequestEvents(pullRequestEvents.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly =
    zio.aws.codecommit.model.DescribePullRequestEventsResponse
      .wrap(buildAwsValue())
}
object DescribePullRequestEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DescribePullRequestEventsResponse =
      zio.aws.codecommit.model.DescribePullRequestEventsResponse(
        pullRequestEvents.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def pullRequestEvents
        : List[zio.aws.codecommit.model.PullRequestEvent.ReadOnly]
    def nextToken: Optional[NextToken]
    def getPullRequestEvents: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.PullRequestEvent.ReadOnly
    ]] = ZIO.succeed(pullRequestEvents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse
  ) extends zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly {
    override val pullRequestEvents
        : List[zio.aws.codecommit.model.PullRequestEvent.ReadOnly] = impl
      .pullRequestEvents()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.PullRequestEvent.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse
  ): zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly =
    new Wrapper(impl)
}
