package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, ApprovalRuleTemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAssociatedApprovalRuleTemplatesForRepositoryResponse(
    approvalRuleTemplateNames: Optional[Iterable[ApprovalRuleTemplateName]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse = {
    import ListAssociatedApprovalRuleTemplatesForRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
      .builder()
      .optionallyWith(
        approvalRuleTemplateNames.map(value =>
          value.map { item =>
            ApprovalRuleTemplateName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvalRuleTemplateNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly =
    zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
      .wrap(buildAwsValue())
}
object ListAssociatedApprovalRuleTemplatesForRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse =
      zio.aws.codecommit.model
        .ListAssociatedApprovalRuleTemplatesForRepositoryResponse(
          approvalRuleTemplateNames.map(value => value),
          nextToken.map(value => value)
        )
    def approvalRuleTemplateNames: Optional[List[ApprovalRuleTemplateName]]
    def nextToken: Optional[NextToken]
    def getApprovalRuleTemplateNames
        : ZIO[Any, AwsError, List[ApprovalRuleTemplateName]] = AwsError
      .unwrapOptionField("approvalRuleTemplateNames", approvalRuleTemplateNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
  ) extends zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly {
    override val approvalRuleTemplateNames
        : Optional[List[ApprovalRuleTemplateName]] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalRuleTemplateNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
  ): zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
