package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ObjectId,
  RepositoryName,
  PullRequestId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MergePullRequestByFastForwardRequest(
    pullRequestId: PullRequestId,
    repositoryName: RepositoryName,
    sourceCommitId: Optional[ObjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest = {
    import MergePullRequestByFastForwardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        sourceCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.sourceCommitId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergePullRequestByFastForwardRequest.ReadOnly =
    zio.aws.codecommit.model.MergePullRequestByFastForwardRequest
      .wrap(buildAwsValue())
}
object MergePullRequestByFastForwardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.MergePullRequestByFastForwardRequest =
      zio.aws.codecommit.model.MergePullRequestByFastForwardRequest(
        pullRequestId,
        repositoryName,
        sourceCommitId.map(value => value)
      )
    def pullRequestId: PullRequestId
    def repositoryName: RepositoryName
    def sourceCommitId: Optional[ObjectId]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("sourceCommitId", sourceCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest
  ) extends zio.aws.codecommit.model.MergePullRequestByFastForwardRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest
  ): zio.aws.codecommit.model.MergePullRequestByFastForwardRequest.ReadOnly =
    new Wrapper(impl)
}
