package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  Content,
  ClientRequestToken,
  CommentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PostCommentReplyRequest(
    inReplyTo: CommentId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    content: Content
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest = {
    import PostCommentReplyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest
      .builder()
      .inReplyTo(CommentId.unwrap(inReplyTo): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .content(Content.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PostCommentReplyRequest.ReadOnly =
    zio.aws.codecommit.model.PostCommentReplyRequest.wrap(buildAwsValue())
}
object PostCommentReplyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PostCommentReplyRequest =
      zio.aws.codecommit.model.PostCommentReplyRequest(
        inReplyTo,
        clientRequestToken.map(value => value),
        content
      )
    def inReplyTo: CommentId
    def clientRequestToken: Optional[ClientRequestToken]
    def content: Content
    def getInReplyTo: ZIO[Any, Nothing, CommentId] = ZIO.succeed(inReplyTo)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest
  ) extends zio.aws.codecommit.model.PostCommentReplyRequest.ReadOnly {
    override val inReplyTo: CommentId =
      zio.aws.codecommit.model.primitives.CommentId(impl.inReplyTo())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codecommit.model.primitives.ClientRequestToken(value)
        )
    override val content: Content =
      zio.aws.codecommit.model.primitives.Content(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest
  ): zio.aws.codecommit.model.PostCommentReplyRequest.ReadOnly = new Wrapper(
    impl
  )
}
