package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait ReplacementTypeEnum {
  def unwrap
      : software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum
}
object ReplacementTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum
  ): zio.aws.codecommit.model.ReplacementTypeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.KEEP_BASE =>
      val r = KEEP_BASE
      r
    case software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.KEEP_SOURCE =>
      val r = KEEP_SOURCE
      r
    case software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.KEEP_DESTINATION =>
      val r = KEEP_DESTINATION
      r
    case software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.USE_NEW_CONTENT =>
      val r = USE_NEW_CONTENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.ReplacementTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object KEEP_BASE extends zio.aws.codecommit.model.ReplacementTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.KEEP_BASE
  }
  case object KEEP_SOURCE extends zio.aws.codecommit.model.ReplacementTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.KEEP_SOURCE
  }
  case object KEEP_DESTINATION
      extends zio.aws.codecommit.model.ReplacementTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.KEEP_DESTINATION
  }
  case object USE_NEW_CONTENT
      extends zio.aws.codecommit.model.ReplacementTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ReplacementTypeEnum.USE_NEW_CONTENT
  }
}
