package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RepositoryId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RepositoryNameIdPair(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    repositoryId: Optional[RepositoryId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair = {
    import RepositoryNameIdPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly =
    zio.aws.codecommit.model.RepositoryNameIdPair.wrap(buildAwsValue())
}
object RepositoryNameIdPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.RepositoryNameIdPair =
      zio.aws.codecommit.model.RepositoryNameIdPair(
        repositoryName.map(value => value),
        repositoryId.map(value => value)
      )
    def repositoryName: Optional[RepositoryName]
    def repositoryId: Optional[RepositoryId]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
  ) extends zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val repositoryId: Optional[RepositoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
  ): zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly = new Wrapper(impl)
}
