package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SymbolicLink(
    blobId: Optional[ObjectId] = Optional.Absent,
    absolutePath: Optional[Path] = Optional.Absent,
    relativePath: Optional[Path] = Optional.Absent,
    fileMode: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.SymbolicLink = {
    import SymbolicLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.SymbolicLink
      .builder()
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(
        absolutePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.absolutePath)
      .optionallyWith(
        relativePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.relativePath)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.SymbolicLink.ReadOnly =
    zio.aws.codecommit.model.SymbolicLink.wrap(buildAwsValue())
}
object SymbolicLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.SymbolicLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.SymbolicLink =
      zio.aws.codecommit.model.SymbolicLink(
        blobId.map(value => value),
        absolutePath.map(value => value),
        relativePath.map(value => value),
        fileMode.map(value => value)
      )
    def blobId: Optional[ObjectId]
    def absolutePath: Optional[Path]
    def relativePath: Optional[Path]
    def fileMode: Optional[zio.aws.codecommit.model.FileModeTypeEnum]
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getAbsolutePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("absolutePath", absolutePath)
    def getRelativePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("relativePath", relativePath)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.SymbolicLink
  ) extends zio.aws.codecommit.model.SymbolicLink.ReadOnly {
    override val blobId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val absolutePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.absolutePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val relativePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.relativePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val fileMode: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.SymbolicLink
  ): zio.aws.codecommit.model.SymbolicLink.ReadOnly = new Wrapper(impl)
}
