package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RuleContentSha256,
  ApprovalRuleTemplateContent,
  ApprovalRuleTemplateName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApprovalRuleTemplateContentRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    newRuleContent: ApprovalRuleTemplateContent,
    existingRuleContentSha256: Optional[RuleContentSha256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest = {
    import UpdateApprovalRuleTemplateContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .newRuleContent(
        ApprovalRuleTemplateContent.unwrap(newRuleContent): java.lang.String
      )
      .optionallyWith(
        existingRuleContentSha256.map(value =>
          RuleContentSha256.unwrap(value): java.lang.String
        )
      )(_.existingRuleContentSha256)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest
      .wrap(buildAwsValue())
}
object UpdateApprovalRuleTemplateContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest =
      zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest(
        approvalRuleTemplateName,
        newRuleContent,
        existingRuleContentSha256.map(value => value)
      )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def newRuleContent: ApprovalRuleTemplateContent
    def existingRuleContentSha256: Optional[RuleContentSha256]
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getNewRuleContent: ZIO[Any, Nothing, ApprovalRuleTemplateContent] =
      ZIO.succeed(newRuleContent)
    def getExistingRuleContentSha256: ZIO[Any, AwsError, RuleContentSha256] =
      AwsError.unwrapOptionField(
        "existingRuleContentSha256",
        existingRuleContentSha256
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest
  ) extends zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val newRuleContent: ApprovalRuleTemplateContent =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateContent(impl.newRuleContent())
    override val existingRuleContentSha256: Optional[RuleContentSha256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.existingRuleContentSha256())
        .map(value =>
          zio.aws.codecommit.model.primitives.RuleContentSha256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest
  ): zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest.ReadOnly =
    new Wrapper(impl)
}
