package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  KeepEmptyFolders,
  Message,
  RepositoryName,
  Email,
  Name,
  BranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCommitRequest(
    repositoryName: RepositoryName,
    branchName: BranchName,
    parentCommitId: Optional[CommitId] = Optional.Absent,
    authorName: Optional[Name] = Optional.Absent,
    email: Optional[Email] = Optional.Absent,
    commitMessage: Optional[Message] = Optional.Absent,
    keepEmptyFolders: Optional[KeepEmptyFolders] = Optional.Absent,
    putFiles: Optional[Iterable[zio.aws.codecommit.model.PutFileEntry]] =
      Optional.Absent,
    deleteFiles: Optional[Iterable[zio.aws.codecommit.model.DeleteFileEntry]] =
      Optional.Absent,
    setFileModes: Optional[
      Iterable[zio.aws.codecommit.model.SetFileModeEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateCommitRequest = {
    import CreateCommitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        parentCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.parentCommitId)
      .optionallyWith(
        authorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(
        putFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.putFiles)
      .optionallyWith(
        deleteFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleteFiles)
      .optionallyWith(
        setFileModes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.setFileModes)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateCommitRequest.ReadOnly =
    zio.aws.codecommit.model.CreateCommitRequest.wrap(buildAwsValue())
}
object CreateCommitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateCommitRequest =
      zio.aws.codecommit.model.CreateCommitRequest(
        repositoryName,
        branchName,
        parentCommitId.map(value => value),
        authorName.map(value => value),
        email.map(value => value),
        commitMessage.map(value => value),
        keepEmptyFolders.map(value => value),
        putFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        setFileModes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def repositoryName: RepositoryName
    def branchName: BranchName
    def parentCommitId: Optional[CommitId]
    def authorName: Optional[Name]
    def email: Optional[Email]
    def commitMessage: Optional[Message]
    def keepEmptyFolders: Optional[KeepEmptyFolders]
    def putFiles: Optional[List[zio.aws.codecommit.model.PutFileEntry.ReadOnly]]
    def deleteFiles
        : Optional[List[zio.aws.codecommit.model.DeleteFileEntry.ReadOnly]]
    def setFileModes
        : Optional[List[zio.aws.codecommit.model.SetFileModeEntry.ReadOnly]]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getParentCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("parentCommitId", parentCommitId)
    def getAuthorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getPutFiles: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.PutFileEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("putFiles", putFiles)
    def getDeleteFiles: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.DeleteFileEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("deleteFiles", deleteFiles)
    def getSetFileModes: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.SetFileModeEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("setFileModes", setFileModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
  ) extends zio.aws.codecommit.model.CreateCommitRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val branchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.branchName())
    override val parentCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.parentCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val authorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.authorName())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val commitMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val keepEmptyFolders: Optional[KeepEmptyFolders] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keepEmptyFolders())
        .map(value =>
          zio.aws.codecommit.model.primitives.KeepEmptyFolders(value)
        )
    override val putFiles
        : Optional[List[zio.aws.codecommit.model.PutFileEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.putFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.PutFileEntry.wrap(item)
          }.toList
        )
    override val deleteFiles
        : Optional[List[zio.aws.codecommit.model.DeleteFileEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.DeleteFileEntry.wrap(item)
          }.toList
        )
    override val setFileModes
        : Optional[List[zio.aws.codecommit.model.SetFileModeEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setFileModes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.SetFileModeEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
  ): zio.aws.codecommit.model.CreateCommitRequest.ReadOnly = new Wrapper(impl)
}
