package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRepositoriesResponse(
    repositories: Optional[
      Iterable[zio.aws.codecommit.model.RepositoryNameIdPair]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse = {
    import ListRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse
      .builder()
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly =
    zio.aws.codecommit.model.ListRepositoriesResponse.wrap(buildAwsValue())
}
object ListRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListRepositoriesResponse =
      zio.aws.codecommit.model.ListRepositoriesResponse(
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def repositories
        : Optional[List[zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse
  ) extends zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly {
    override val repositories: Optional[
      List[zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.RepositoryNameIdPair.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse
  ): zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly = new Wrapper(
    impl
  )
}
